% function [] = PointCloudProcessor(arg)
%
% Usage:
%            >> PointCloudProcessor('init');
%
% This function displays point clouds in 3D and then fits a polynomial
% function to the cloud. Additionally, you can wrap a 4D surface around the
% cloud which is visualised by level surfaces.
%
%
% Dr. A. I. Hanna (2005)
function [] = PointCloudProcessor(arg,option)
global AAMShapemodel_figure_handle
global AAMModelGenerator_handle
global AAMModelBuilder_handle
global AAMSetPicker_handle
global UpdateModel_handle
global PMTemplateBuilder_handle
global PDMWalk_handle
global ShapeSpaceTool_handle
global PreProcess_gui_handle
global axesFig_handle
if nargin<2
    option='pdm';
end
if strcmp(class(arg), 'AAM')
        pdm = get(arg, 'pdm');
    if isempty(pdm)
            uiwait(warndlg('No PDM found','PDM Error'));
            return;
    end
    % Open the GUI for display
    if exist('AAMShapemodel_figure_handle')
        if ishandle(AAMShapemodel_figure_handle)
            set(AAMShapemodel_figure_handle,'visible','off');
        end
    end
    fig = openfig(mfilename, 'reuse');
    Data.handles = guihandles(fig);
    Data.handles.AAM = arg;
    Data.handles.groups = [];
    Data.option=option;
    Data.handles.figMain = fig;
    ShapeSpaceTool_handle = fig;
    Data.handles.axesFig =  openfig('MainAxes', 'reuse');
    axesFig_handle=Data.handles.axesFig;
    set(gca,'Position',[0.1 0.1 0.8 0.8])
    axis on
    Data.handles.UIContextMenu=uicontextmenu;
    uimenu(Data.handles.UIContextMenu,'Label','Original image','Callback',[mfilename, '(''ShowOriginalImage'');']);
    uimenu(Data.handles.UIContextMenu,'Label','Modelled image','Callback',[mfilename, '(''ShowModelledImage'');']);
    uimenu(Data.handles.UIContextMenu,'Label','Now click on target pointmodel','Callback',[mfilename, '(''ShowFullModelImage'');']);
    if exist('PDMWalk_handle')
        if isempty(PDMWalk_handle)
            Data.FigNo=0;
        else
            Data.FigNo=PDMWalk_handle;
        end
    else
        Data.FigNo=0;
    end
    Data.PC = [];
    Data.RegCurve = {};
    Data.handles.groups = [];
    Data.SurfaceData.X = [];
    Data.SurfaceData.Y = [];
    Data.SurfaceData.Z = [];
    Data.SurfaceData.V = [];
    Data.Pcomponents=1:3;
    Data.FitOpt = 'Data';
    Data.handles = LoadGroupInfo(Data.handles); %Data.Pcomponents,option);
    Data.PC = Data.handles.PC;
    Data.RegCurve = cell(1, length(Data.PC));
    Data.SurfaceData = cell(1, length(Data.PC));
    for i=1:length(Data.PC)
        Data.SurfaceData{i}.X = [];
        Data.SurfaceData{i}.Y = [];
        Data.SurfaceData{i}.Z = [];
        Data.SurfaceData{i}.V = [];
    end
    Data.handles =PlotData(Data.handles, Data.PC, Data.RegCurve, Data.SurfaceData,Data.Pcomponents,Data.option);
    guidata(fig, Data);
    set(Data.handles.figMain, 'DoubleBuffer', 'on');%, 'Toolbar', 'figure');

else
    Data = guidata(findobj('Tag', 'ControlGui'));
    %    Data = guidata(gcbo);
    switch arg
        case 'ShowPlot'
            Data=ShowPlot(Data);
        case 'ShowImage'
            Data=ShowImage(Data);
        case 'ShowModel'
            Data=ShowModel(Data);
        case 'Plot3D2'
            Data=Plot3D2(Data);
        case 'SetView'
            Data=SetView(Data);
        case 'ShowOriginalImage'
            Data=ShowOriginalImage(Data);
        case 'ShowModelledImage'
            Data=ShowModelledImage(Data);
        case 'ShowFullModelImage'
            Data=ShowFullModelImage(Data);
        case 'LoadData'
            [Data.PC] = LoadData();
            Data.RegCurve = cell(1, length(Data.PC));
            Data.SurfaceData = cell(1, length(Data.PC));
            for i=1:length(Data.PC)
                Data.SurfaceData{i}.X = [];
                Data.SurfaceData{i}.Y = [];
                Data.SurfaceData{i}.Z = [];
                Data.SurfaceData{i}.V = [];
            end
        case 'PlotData'
            Data.handles = PlotData(Data.handles, Data.PC, Data.RegCurve, Data.SurfaceData, Data.Pcomponents,Data.option);
        case 'ToggleZoom'
            Data.handles = ToggleZoom(Data.handles);
        case 'Pcomponents'
            Data = Pcomponents(Data);
            Data.handles = PlotData(Data.handles, Data.PC, Data.RegCurve, Data.SurfaceData, Data.Pcomponents,Data.option);
        case 'TogglePan'
            Data.handles = TogglePan(Data.handles);
        case 'PrintEPS'
            PrintEPS(Data.handles);
        case 'AddGroup'
            Data.handles = AddGroup(Data.handles);
        case 'DeleteGroup'
            Data.handles = DeleteGroup(Data.handles);
        case 'UpdateGroupInfo'
            Data.handles = UpdateGroupInfo(Data.handles);
        case 'ShowStats'
            Data = ShowStats(Data);
        case 'ShowMeans'
            Data = ShowMeans(Data);
        case 'Rotate'
            Data = Rotate(Data);
        case 'Select'
            Data = Select(Data);
        case 'FitData'
            [Data.RegCurve, Data.SurfaceData] = FitData(Data.handles, Data.PC, Data.FitOpt);
            Data.handles = PlotData(Data.handles, Data.PC, Data.RegCurve, Data.SurfaceData,Data.Pcomponents,Data.option);
        case 'ChangeColor'
            [Data.handles] = ChangeColor(Data.handles);
            Data.handles = PlotData(Data.handles, Data.PC, Data.RegCurve, Data.SurfaceData,Data.Pcomponents,Data.option);
        case 'ShowNumbers'
            Data.handles = PlotData(Data.handles, Data.PC, Data.RegCurve, Data.SurfaceData,Data.Pcomponents,Data.option);
        case 'Quit'
            if Data.FigNo>0
                %close all
            end
            groups = Data.handles.groups;
            %if ~isempty(groups)
           % end
            if exist('AAMShapemodel_figure_handle')
                if ishandle(AAMShapemodel_figure_handle)
                    set(AAMShapemodel_figure_handle,'visible','on');
                end
            end
            [Data.handles] = Quit(Data.handles);
        otherwise
            error('Unknown Option in PointCloudProcessor');
    end
    if isfield(Data.handles, 'figMain')
        guidata(Data.handles.figMain, Data);
    end
end

function  Data=ShowImage(Data)
if isfield(Data.handles,'orig_image')
    if get(Data.handles.ShowImage,'Value')
        set(Data.handles.orig_image,'Visible','on');
    else
        set(Data.handles.orig_image,'Visible','off');
    end
end

function  Data=ShowPlot(Data)
if isfield(Data.handles,'orig_plot')
    if get(Data.handles.ShowPlot,'Value')
        set(Data.handles.orig_plot,'Visible','on');
    else
        set(Data.handles.orig_plot,'Visible','off');
    end
end
function  Data=ShowModel(Data)
if isfield(Data.handles,'orig_model')
    if get(Data.handles.ShowModel,'Value')
        set(Data.handles.orig_model,'Visible','on');
        set(Data.handles.orig_plot,'Color','r');
    else
        set(Data.handles.orig_model,'Visible','off');
        set(Data.handles.orig_plot,'Color','k');
    end
end

function Data=Plot3D2(Data)
if get(Data.handles.Plot3D2,'Value')
    set(Data.handles.Plot3D2,'Value',1);
    set(Data.handles.Plot3D2,'String','Plot 2D');
else
    set(Data.handles.Plot3D2,'Value',0);
    set(Data.handles.Plot3D2,'String','Plot 3D');
end

function Data=SetView(Data)
% project onto the viewing axis
Data.handles.meanPC

function [Data,positions,pts1]=ShowImageData(Data,Option,ExternalXm,positions)
dat=get(gco,'UserData');
%FigNo=max(get(0,'Children'));
%Data.FigNo=FigNo+1;
Data.FigNo=Data.FigNo+1;
%Data.handles.axesFigimage =  openfig(d, 'reuse');
mp=get(0,'MonitorPositions');
wid=mp(1,3);
ht=mp(1,4);
dht=ht/8;
if nargin<4
    pos1=[((Data.FigNo-1)/2)*wid/10,ht-dht*1.5,wid/10,dht];
    positions{1}=pos1;
else
    pos1=positions{1};
end
figure(Data.FigNo);
set(Data.FigNo,'Name',sprintf('%d/%d %s',dat.region,dat.num,dat.filename),'Position', pos1);
if nargin<4
    pos2=[((Data.FigNo-1)/2)*wid/10,ht-2*dht*1.5,wid/10,dht];
    positions{2}=pos2;
else
    pos2=positions{2};
end
Data.FigNo=Data.FigNo+1;
figure(Data.FigNo);
set(Data.FigNo,'Name',sprintf('%d/%d %s',dat.region,dat.num,dat.filename),'Position', pos2);
% set up pos1 and pos2 ready for the next call (if it comes)
pos1=[((Data.FigNo-1)/2)*wid/10,dht*1.5,wid/10,dht];
pos2=[((Data.FigNo-1)/2)*wid/10,2*dht*1.5,wid/10,dht];
% i.e. put the next two figures at the bottom of the main window
AAM=Data.handles.AAM;
md=get(AAM,'modelDirec');
pmt=get(AAM,'PointModelTemplate');
loops=get(pmt,'loops');
edges=loops{1};
temp=load(fullfile(md,'mod_sfam.mat'),'-mat');
aam=temp.sfam;
pdm=aam.pdm;
if nargin<3,
    Xm=pdm.Xm;
else
    Xm=ExternalXm;
end
%dat.bAll
if dat.num<0 % overall mean
    img = double(aam.Am); %+aam.P * bWA;
    pts1=Xm;
elseif dat.num==0 % group mean
    bW=zeros(size(pdm.P,2),1);
    ind=1:size(dat.bAll,2);
    bW(ind)=dat.bAll(:);
    img = double(aam.Am); % + aam.P * dat.PC);
    pts1=Xm+ pdm.P * bW;
    %pts1=pdm.Xm+ pdm.P * (bW.*sqrt(pdm.b));
else % individual image
    bW=zeros(size(pdm.P,2),1);
    ind=1:size(dat.bAll,2);
    bW(ind)=dat.bAll(:);
    img = double(aam.Am); % + aam.P * dat.PC);
    pts1=Xm+ pdm.P * bW;
    %pts1=pdm.Xm+ pdm.P * (bW.*sqrt(pdm.b));
end
img = reshape(img, [aam.siz(2), aam.siz(1), 3]);
pts(:,1)=pts1(1:2:end); 
pts(:,2)=pts1(2:2:end);

imfilename=dat.filename(1:findstr(dat.filename,'_pm.mat')-1);
file=fullfile('Cropped',[imfilename,'.jpg']);
if exist(file)==2
    picture_img=imread(file);
else
    picture_img=[];
end
%picture_img=imresize(imread(file),[size(picture_img,1),size(picture_img,2)]);;
if ~isfield(Data.handles,'orig_image')
    Data.handles.orig_image=[];
end
figure(Data.FigNo-1)
Data.handles.orig_image(end+1)=imshow(uint8(picture_img),'InitialMagnification','fit');
iptsetpref('ImshowBorder','tight');
hold on
text(5,0.08*size(picture_img,1),sprintf('%d/%d',dat.region,dat.num),'color','r');
hold off

pts(:,1)=pts(:,1)-min(pts(:,1));
pts(:,2)=pts(:,2)-min(pts(:,2));
picture_img=triwarp(img,aam.ompts,pts); % upsample to zero offset
if ~isfield(Data.handles,'orig_model')
    Data.handles.orig_model=[];
end
figure(Data.FigNo)
clf
if ~isempty(picture_img)
    Data.handles.orig_model(end+1)=imshow(uint8(picture_img),'InitialMagnification','fit');
end
iptsetpref('ImshowBorder','tight');
hold on
text(5,0.08*size(picture_img,1),sprintf('%d/%d',dat.region,dat.num),'color','r');
hold off

if ~isfield(Data.handles,'orig_plot')
    Data.handles.orig_plot=[];
end
hold on
inds=get(AAM,'pointindices'); % only use points within current set
for i=1:length(edges)
    if ~isempty(intersect(inds,edges(i,:)))
        ii=find(inds==edges(i,1));
        jj=find(inds==edges(i,2));
        Data.handles.orig_plot(end+1)=plot([pts(ii,1),pts(jj,1)],[pts(ii,2),pts(jj,2)],'-r');
    end
end
hold off
%end
%end
if isfield(Data.handles,'orig_model')
    if get(Data.handles.ShowModel,'Value')
        set(Data.handles.orig_model,'Visible','on');
    else
        set(Data.handles.orig_model,'Visible','off');
    end
end
if isfield(Data.handles,'orig_image')
    if get(Data.handles.ShowImage,'Value')
        set(Data.handles.orig_image,'Visible','on');
    else
        set(Data.handles.orig_image,'Visible','off');
    end
end
if isfield(Data.handles,'orig_plot')
    if get(Data.handles.ShowPlot,'Value')
        set(Data.handles.orig_plot,'Visible','on');
    else
        set(Data.handles.orig_plot,'Visible','off');
    end
end

function Data=ShowOriginalImage(Data)
Option=0;
Data=ShowImageData(Data,Option);

function Data=ShowModelledImage(Data)
Option=1;
Data=ShowImageData(Data,Option);

function Data=ShowFullModelImage(Data)
Option=2;
[Data,positions,model]=ShowImageData(Data,Option);
AAM=Data.handles.AAM;
md=get(AAM,'modelDirec');
pmt=get(AAM,'PointModelTemplate');
loops=get(pmt,'loops');
edges=loops{1};
temp=load(fullfile(md,'mod_sfam.mat'),'-mat');
aam=temp.sfam;
pdm=aam.pdm;
%Data=ShowImageData(Data,Option,pdm.Xm,pos1,pos2);


function [Data] = Rotate(Data)
if get(Data.handles.Rotate,'Value')
     set(Data.handles.Rotate,'Value',1);
     set(Data.handles.Select,'Value',0);
     figure(Data.handles.axesFig);
     rotate3D on
else
     set(Data.handles.Rotate,'Value',0);
     set(Data.handles.Select,'Value',1);
     figure(Data.handles.axesFig);
     rotate3D off
end

function [Data] = Select(Data)
if get(Data.handles.Select,'Value')
     set(Data.handles.Rotate,'Value',0);
     set(Data.handles.Select,'Value',1);
     figure(Data.handles.axesFig);
     rotate3D off
else
     set(Data.handles.Rotate,'Value',1);
     set(Data.handles.Select,'Value',0);
     figure(Data.handles.axesFig);
     rotate3D on
end

function [Data] = Pcomponents(Data)
temp_Pcomponents=[];
while length(temp_Pcomponents)~=3
    a=inputdlg('Please key in the numbers for three axis, default 1:3 (e.g. 2,3,5)','Set axis for display');
    if isempty(a)
        a={sprintf('1:3')};
    end
    s=sprintf('temp_Pcomponents=str2num(a{1});');
    eval(s);
    if length(temp_Pcomponents)~=3
        disp('requires three axis for the display')
    end
end
Data.Pcomponents=temp_Pcomponents;    

function [handles] = ChangeColor(handles)
groups = handles.groups;
v = get(handles.groupList, 'value');
if isempty(v)
    return;
end
color = uisetcolor;
group = groups(v);
group.color = color;
groups(v) = group;
handles.groups = groups;
save([get(handles.AAM, 'modelDirec'), filesep, 'groups.mat'],'groups' );
handles = UpdateGroupInfo(handles);

return;

function [handles] = DeleteGroup(handles)
groups = handles.groups;
v = get(handles.groupList, 'value');
if isempty(v)
    return;
end
groups(v) = [];
handles.groups = groups;
save([get(handles.AAM, 'modelDirec'), filesep, 'groups.mat'],'groups' );
handles = UpdateGroupInfo(handles);


function [handles] = UpdateGroupInfo(handles)
groups = handles.groups;
if isempty(groups)
    set(handles.groupMemberList, 'String', '');
    set(handles.groupList, 'String', '');
    return;
else
indx = get(handles.groupList, 'value');
indx = min(indx, length(groups));
group = groups(indx);
for i=1:length(group.elements)
    tempstring{i}=sprintf('%3d) %s',i,group.elements{i});
end
set(handles.groupMemberList, 'String', tempstring);
set(handles.groupList, 'value', indx);
set(handles.groupList, 'String', {groups.name});
end


function [handles] = AddGroup(handles)
template = get(handles.AAM, 'PointModelTemplate');
template_name = get(template, 'name');
[templatepath, template_name, ext, vers] = fileparts(template_name);
if ~exist(['PointModels', filesep, template_name], 'dir')
    fprintf('There are no point models for this template');
    return;
end
files = dir(['PointModels', filesep, template_name,filesep, '*_pm.mat']);
files = {files.name};
[s, v] = CustomListDlg(files);
if isempty(v)
    return;
end
prompt={'Enter the logical name of the new group:'};
name='Group Name';
numlines=1;
defaultanswer={'New group'};
answer=inputdlg(prompt,name,numlines,defaultanswer);
if isempty(answer)
    return;
end
groups = handles.groups;
groups(end+1).name = answer{1};
groups(end).elements = s;
%colours='rgbcmyk';
colours=[...
    1 0 0;...
    0 1 0;...
    0 0 1;...
    1 0 1;...
    0 1 1;...
    1 1 0;...
    0.5 0.5 0.5;...
    0.5 0.0 0.5;...
    0.0 0.5 0.5;...
    1 0.5 0.5;...
    1 0.0 0.5;...
    0.0 1 0.5;...
    0.5 1.0 0.5;...
    0.5 0.0 1.0;...
    0.0 0.5 1.0;...
    ];
cc=rem(length(groups)-1,size(colours,1))+1;
groups(end).color = colours(cc,:);%[1 0 0];
{groups.name}
set(handles.groupList, 'value', 1);
set(handles.groupList, 'String', {groups.name});
handles.groups = groups;
handles = UpdateGroupInfo(handles);
save([get(handles.AAM, 'modelDirec'), filesep, 'groups.mat'],'groups' );

function [handles] = LoadGroupInfo(handles,Pcomponents,option)
if nargin<2
    Pcomponents=1:3;
end
if nargin<3
    option='pdm';
end
aam = handles.AAM;
PMT = get(aam, 'PointModelTemplate');
templatename = get(PMT, 'name');
[path, templatename, ext, vers] = fileparts(templatename);
if strcmp(option,'pdm')
    pdm = get(aam, 'pdm');
else
    pdm = aam; %get(aam, 'pdm');
end
if isempty(pdm)
    return;
end
Xm = pdm.Xm;
P = pdm.P;
PC = [];
aam = handles.AAM;
modelDirec=get(aam,'modelDirec');
PMT = get(aam, 'PointModelTemplate');
loops=get(PMT,'loops');
edges=loops{1};
templatename = get(PMT, 'name');
[path, templatename, ext, vers] = fileparts(templatename);
% Now we must load the group information
model_dir = get(handles.AAM, 'modelDirec');
if exist([model_dir, filesep, 'groups.mat'])
    groups = load([model_dir, filesep, 'groups.mat']);
else
    handles.groups = [];
    handles.PC = [];
    handles = UpdateGroupInfo(handles);
    return;
end
groups = groups.groups;
%---
projectname=get(PMT,'name');
modelDirec=get(aam,'modelDirec'); %temp(1:findstr(temp,'mod_pdm.mat')-2);
modelname=modelDirec(length('StatisticalModels\')+1:end);
detailstr=sprintf('%s  %s  ',projectname,modelname);
if exist(fullfile(modelDirec,'details.mat'))==2
    temp2=load(fullfile(modelDirec,'details.mat'),'-mat');
    details=temp2.details;
    detailstr=sprintf('%s %d pixels, normalised: ',detailstr,details.pixelnumber);
    if details.scaling==1
        detailstr=sprintf('%s Scaling',detailstr);
    end
    if details.rotation==1
        detailstr=sprintf('%s Rotation',detailstr);
    end
    if details.translation==1
        detailstr=sprintf('%s Translation',detailstr);
    end
    if isfield(details,'FractionPCs')
        detailstr=sprintf('%s (%2.1f%% Var.)',detailstr,100*details.FractionPCs);
    end
    set(handles.Details_panel,'Title',detailstr);
% else
%     details=[];
%     detailstr='';
end
Data.details=details;
pdm=get(aam,'pdm'); % model only includes the subset of pointmodels
%---
handles.PC = {};
%figure(20);
for g=1:length(groups)
    PC = [];
    bAll=[];
    group = groups(g);
    imagenames = group.elements;
    imagefilename={};
    thumbnail={};
    for i=1:length(imagenames)
        name = imagenames{i};
        [path, name, ext, vers] = fileparts(name);
        if exist(['PointModels', filesep,templatename, filesep, name,'.mat'])
            temp =load(['PointModels', filesep,templatename, filesep, name,'.mat']);
            pts_temp = temp.pts;
            pts_temp = reshape(pts_temp, 2, length(pts_temp)/2);
            pts = pts_temp(:, get(aam, 'pointindices')); % take just the subset of points
            pts = pts(:); % next align the points using the appropriate details
            ptsa=pmalign(pts,[Data.details.scaling,Data.details.rotation,Data.details.translation],pdm.Xm);
            %ba = P'*(pts-Xm);
            ba = P'*(ptsa-Xm);
            b = ba./sqrt(pdm.b);
            bAll(end+1,:)=ba;
            PC(end+1,:) = b(Pcomponents); %(1:3)';  % can we take more than first 3
            %disp(b(Pcomponents)')
            imname=[name(1:findstr(name,'_pm')-1),'.jpg'];
            imagefilename{i}=fullfile(modelDirec,imname);
            thumbnail{i}=imread(imagefilename{i});
%             imfilename2=fullfile('Cropped',imname);
%             img=imread(imfilename2);
%             imshow(img);hold on;plot(pts(1:2:end),pts(2:2:end),'*r');hold off; drawnow
%             model = pdm.Xm + pdm.P * ba; % * pdm.multi;
%             hold on;plot(model(1:2:end),model(2:2:end),'-r');hold off; drawnow
        end
    end
    handles.PC{g}.pts = PC;
    handles.PC{g}.color = group.color;
    handles.PC{g}.name = group.name;
    handles.bAll{g}=bAll;
    handles.imname{g}=imname;
    handles.thumbnail{g}=thumbnail;
end
%close 20
handles.groups = groups;
handles = UpdateGroupInfo(handles);

function [handles] = Quit(handles)
delete(handles.figMain);
if isfield(handles, 'axesFig')
    delete(handles.axesFig);
end
handles = rmfield(handles, 'figMain');
return;
function [handles] = TogglePan(handles)
if get(handles.togglePan,'Value')
    axes(handles.mainAxes)
    rotate3d off;
    zoom off;
    set(handles.toggleZoom, 'Value', 0);

    pan on;
else
    axes(handles.mainAxes)
    rotate3d on;
    pan off;
end
return;
%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Toggle Zoom
%
%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles] = ToggleZoom(handles)
if get(handles.toggleZoom,'Value')
    axes(handles.mainAxes)
    rotate3d off;
    zoom on;
    set(handles.togglePan, 'Value', 0);

else
    axes(handles.mainAxes)
    rotate3d on;
    zoom off;
end
return;
%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% PlotData
%
%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles] = PlotData(handles, PCS, RegCurveS, SDS, Pcomponents,option)
if nargin<5
    Pcomponents=1:3;
end
if nargin<6
    option='pdm';
end
[handles] = LoadGroupInfo(handles,Pcomponents,option);
PCS= handles.PC;
%title(sprintf('Components %d  %d  %d',Pcomponents(1),Pcomponents(2),Pcomponents(3)))
set(handles.plotDataBtn,'String',sprintf('Plot %d %d %d',Pcomponents(1),Pcomponents(2),Pcomponents(3)));
%if get(handles.Plot3D2,'Value')
    set(gcf, 'renderer', 'zbuffer');
%end

RegCurveS = cell(1, length(PCS));
SDS = cell(1, length(PCS));
for i=1:length(PCS)
    SDS{i}.X = [];
    SDS{i}.Y = [];
    SDS{i}.Z = [];
    SDS{i}.V = [];
end
figure(handles.axesFig);
handles.mainAxes = gca;
cp = get(handles.mainAxes, 'CameraPosition');
cla(handles.mainAxes);
hold on
for region  = 1:length(PCS)
    clear PC
    PC = PCS{region}.pts;
    COLOR = PCS{region}.color;
    RegCurve = RegCurveS{region};
    SD = SDS{region};
    dat.region=region;
    dat.groupname=PCS{region}.name;
    dat.colour=COLOR;
    temp=handles.bAll{region};
    dat.Pcomponents=Pcomponents;
    if(size(PC,1)>0) & (get(handles.showParticles,'value')==1)
        if rem(region,3)==0
            for i=1:size(PC,1)
                dat.num=i;
                dat.PC=PC(i,:);
                dat.filename=handles.groups(region).elements{i};
                dat.bAll=temp(i,:);
                if get(handles.Plot3D2,'Value')
                    ph=plot3(PC(i,1), PC(i,2), PC(i,3), 'o', 'MarkerFaceColor', COLOR, 'MarkerEdgeColor', COLOR, 'MarkerSize', 5);
                else
                    ph=plot(PC(i,1), PC(i,2), 'o', 'MarkerFaceColor', COLOR, 'MarkerEdgeColor', COLOR, 'MarkerSize', 5);
                end
                set(ph,'UserData',dat,'UIContextMenu',handles.UIContextMenu);
            end
        elseif rem(region,3)==1
            for i=1:size(PC,1)
                dat.num=i;
                dat.PC=PC(i,:);
                dat.filename=handles.groups(region).elements{i};
                dat.bAll=temp(i,:);
                if get(handles.Plot3D2,'Value')
                    ph=plot3(PC(i,1), PC(i,2), PC(i,3), '*', 'MarkerFaceColor', COLOR, 'MarkerEdgeColor', COLOR, 'MarkerSize', 5);
                else
                    ph=plot(PC(i,1), PC(i,2), '*', 'MarkerFaceColor', COLOR, 'MarkerEdgeColor', COLOR, 'MarkerSize', 5);
                end
                set(ph,'UserData',dat,'UIContextMenu',handles.UIContextMenu);
            end
        elseif rem(region,3)==2
            for i=1:size(PC,1)
                dat.num=i;
                dat.PC=PC(i,:);
                dat.filename=handles.groups(region).elements{i};
                dat.bAll=temp(i,:);
                if get(handles.Plot3D2,'Value')
                    ph=plot3(PC(i,1), PC(i,2), PC(i,3), '+', 'MarkerFaceColor', COLOR, 'MarkerEdgeColor', COLOR, 'MarkerSize', 5);
                else
                    ph=plot(PC(i,1), PC(i,2), '+', 'MarkerFaceColor', COLOR, 'MarkerEdgeColor', COLOR, 'MarkerSize', 5);
                end
                set(ph,'UserData',dat,'UIContextMenu',handles.UIContextMenu);
            end
        end
        if get(handles.ShowNumbers,'Value')
            for i=1:size(PC,1) % PC images
                dat.num=i;
                dat.PC=PC(i,:);
                dat.filename=handles.groups(region).elements{i};
                dat.bAll=temp(i,:);
                if get(handles.Plot3D2,'Value')
                    ph=text(PC(i,1), PC(i,2), PC(i,3),sprintf('%3d',i),'color',COLOR);
                else
                    ph=text(PC(i,1), PC(i,2),sprintf('%3d',i),'color',COLOR);
                end
                set(ph,'UserData',dat,'UIContextMenu',handles.UIContextMenu);
            end
        end
    end
    %set(handles.mainAxes, 'Visible', 'on', 'Box', 'on');
    %set(handles.mainAxes, 'Color', [.831 .816 .784]);
    hold on;
    if (size(RegCurve,1)>0) & (get(handles.showFit,'value')==1)
        plot3(RegCurve(:,1), RegCurve(:,2), RegCurve(:,3), 'r', 'LineWidth', 2);
    end
    if (size(PC,1)>1) & (get(handles.showSurface,'value')==1)
        if (size(SD.V,1) > 0) & (length(size(SD.V)) == 3)
            scale = get(handles.radiusSlider, 'value');
            set(handles.radiusTxt, 'String', num2str(scale));
            p = patch(isosurface(SD.X, SD.Y, SD.Z, SD.V, scale));
            isonormals(SD.X, SD.Y, SD.Z, SD.V, p);
            set(p, 'FaceAlpha', .5, 'FaceColor', COLOR, 'EdgeColor', 'none');
        end
    end
    if (size(PC,1)>1) & (get(handles.showEllipsoid,'value')==1)
        fprintf('Region %d , Size: %d\n', region, size(PC,1));
        [D, mu] = fit_ellipse(PC);
        h = surf(D.x, D.y, D.z);
        set(h, 'FaceAlpha', .5, 'FaceColor', COLOR, 'EdgeColor', COLOR);
    end
    if (size(PC,1)>1) & (get(handles.showConvHull,'value')==1)
        fprintf('Region %d , Size: %d\n', region, size(PC,1));
        C = convhulln(PC);
        for i = 1:size(C,1)
            j = C(i,[1 2 3 1]);
            patch(PC(j,1),PC(j,2),PC(j,3),rand,'FaceAlpha',0.6);
        end
    end
    if size(PC,1)==1
        mr=PC;
        mall=bAll;
    else
        mr = mean(PC);
        mall=mean(temp);
    end
    handles.meanPC(region,:)=mr;
    dat.num=0;
    dat.PC=mr;
    dat.filename=sprintf('Group_%d',region);
    dat.bAll=mall;
    if get(handles.Plot3D2,'Value')
        ph=plot3(mr(1), mr(2), mr(3),'O','MarkerFaceColor',COLOR,'MarkerEdgeColor','k','MarkerSize',10);
    else
        ph=plot(mr(1), mr(2),'O','MarkerFaceColor',COLOR,'MarkerEdgeColor','k','MarkerSize',10);
    end
    set(ph,'UserData',dat,'UIContextMenu',handles.UIContextMenu);
    text(mr(1)+0.3, mr(2)+0.3, mr(3)+0.3, PCS{region}.name,'Color',COLOR);
    if region==1
        bAllPC=PC;
    else
        bAllPC=[bAllPC;PC];
    end
end
if exist('bAllPC')
    meanbAllPC=mean(bAllPC);
    if get(handles.Plot3D2,'Value')
        ph=plot3(meanbAllPC(1), meanbAllPC(2), meanbAllPC(3),'X','MarkerFaceColor',COLOR,'MarkerEdgeColor','k','MarkerSize',12);
    else
        ph=plot(meanbAllPC(1), meanbAllPC(2),'X','MarkerFaceColor',COLOR,'MarkerEdgeColor','k','MarkerSize',12);
    end
    dat.num=-1;
    dat.PC=zeros(size(meanbAllPC,2));
    dat.region=0;
    dat.groupname='Overall Mean';
    dat.filename='Overall_Mean';
    dat.Pcomponents=Pcomponents;
    set(ph,'UserData',dat,'UIContextMenu',handles.UIContextMenu);

    hold off
end
%set(gca, 'DrawMode', 'fast', 'Color', [0 0 0], 'XColor', [1 1 1], 'YColor', [1 1 1], 'ZColor', [1 1 1]);
set(gca, 'Color', [1 1 1], 'XColor', [0 0 0], 'YColor', [0 0 0], 'ZColor', [0 0 0]);
%set(handles.mainAxes, 'CameraPosition', cp);
grid on;
drawnow; hold off;
xlabel(sprintf('PC %d',Pcomponents(1)));
ylabel(sprintf('PC %d',Pcomponents(2)));
zlabel(sprintf('PC %d',Pcomponents(3)));
set(gca,'DataAspectRatio',[1 1 1]);
%xlabel(['PC 1');ylabel('PC 2');zlabel('PC 3');
%camlight left;
%lighting phong;
p = get(gcf, 'PointerShapeCData');
ind = find(p==1);
p(ind) = 2;
set(gcf, 'PointerShapeCData', p);
%rotate3d on;
%axis vis3d;
fprintf('Using %s as the renderer\n', get(gcf, 'renderer'));
if get(handles.Plot3D2,'Value')
    disp('plotting in 3D');
else
    disp('plotting in 2D');
end
%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% PlotData
%
%%%%%%%%%%%%%%%%%%%%%%%%%%
function Data = ShowStats(Data)

[Data.handles] = LoadGroupInfo(Data.handles);
bAll= Data.handles.bAll; %one cell per group, 
                    %one row per image, one column per component
fig_i=1;
figure(1);clf
fig_i=fig_i+1;
c='mkrgbcy';
for i  = 1:length(bAll)
    figure(fig_i)
    fig_i=fig_i+1;
    pc_means=mean(bAll{i});
    pc_std=std(bAll{i});
    pc_ste=pc_std/sqrt(length(bAll));
    errorbar(1:length(pc_means),pc_means,pc_ste,'color',c(1+rem(i,length(c)-1)));
    axis([0 length(pc_means) -4 4]);
    title(handles.groups(i).name);
    xlabel('Component');
    figure(1);
    hold on
    errorbar(1:length(pc_means),pc_means,pc_ste,'color',c(1+rem(i,length(c)-1)));
    axis([0 length(pc_means) -4 4]);
    hold off
end

%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% PrintEPS
%
%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = PrintEPS(handles);
[filename, pathname] = uiputfile('*.eps', 'Choose filename');
if isequal(filename,0) | isequal(pathname,0)
    disp('User cancelled printing.')
else
    h1=figure;
    set(h1, 'Visible', 'off', 'Units',get(handles.figMain, 'Units'),  'Position', get(handles.figMain, 'Position'), 'PaperPositionMode','auto');
    h2=copyobj(handles.mainAxes,h1); % handles.axes1 is the object to print
    set(h1, 'PaperType', 'A4', 'PaperPosition', [0 0 10 10]);
    fn = [pathname, filesep, filename];
    print(h1, '-depsc', fn);
    close(h1);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Load Data
%
%%%%%%%%%%%%%%%%%%%%%%%%%%
function [PC] = LoadData()
[filename, pathname] = uigetfile('*.pcdat', 'Please open a valid Point Cloud File');
if isequal(filename, 0) | isequal(pathname, 0)
    disp('User pressed cancel to load point cloud');
    PC = [];
else
    PC = load([pathname, filesep, filename],'-mat');
    PC = PC.Data;
    if strcmp(class(PC), 'double')
        PC{1}.pts =PC;
        PC{1}.color = [1 0 0];
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% FitData
%
%%%%%%%%%%%%%%%%%%%%%%%%%%
function [REGCURVES, SDS] = FitData(handles, PCS, fitOpt)
for region = 1:length(PCS)
    PC = PCS{region}.pts;
    [X,Y,Z] = poly3dfit(PC(:,1), PC(:,2), PC(:,3), [get(handles.xpolyorder, 'value'),get(handles.ypolyorder, 'value')], 1000);
    RegCurve = [X, Y, Z];
    xmin = min(PC(:,1))-1; xmax = max(PC(:,1))+1; dx = 10;
    ymin =min(PC(:,2))-1; ymax = max(PC(:,2))+1; dy = 10;
    zmin = min(PC(:,3))-1; zmax = max(PC(:,3))+1; dz = 10;
    dx = (xmax - xmin)/50;
    dy = (ymax - ymin)/50;
    dz = (zmax - zmin)/50;

    [X, Y, Z] = meshgrid([xmin:dx:xmax],[ymin:dy:ymax],[zmin:dz:zmax] );
    V = zeros(size(X));
    for i=1:size(X,1)
        for j=1:size(X,2)
            for k = 1:size(X,3)
                if get(handles.fitToData, 'value')
                    [v, p] = min(sqrt((PC(:,1) - X(i,j,k)).^2 + (PC(:,2) - Y(i,j,k)).^2 + (PC(:,3) - Z(i,j,k)).^2 ));
                    V(i, j, k) = sum(sqrt((PC(p,1) - X(i,j,k)).^2 + (PC(p,2) -Y(i,j,k)).^2 + (PC(p,3) - Z(i,j,k)).^2 )) ;
                else
                    [v, p] = min(sqrt((RegCurve(:,1) - X(i,j,k)).^2 + (RegCurve(:,2) - Y(i,j,k)).^2 + (RegCurve(:,3) - Z(i,j,k)).^2 ));
                    V(i, j, k) = sum(sqrt((RegCurve(p,1) - X(i,j,k)).^2 + (RegCurve(p,2) - Y(i,j,k)).^2 + (RegCurve(p,3) - Z(i,j,k)).^2 )) ;
                end
            end
        end
    end
    REGCURVES{region} = RegCurve;
    SDS{region}.X = X;
    SDS{region}.Y = Y;
    SDS{region}.Z = Z;
    SDS{region}.V = V;
end
% function [data] = fit_ellipse(PC);
%
% Input: PC is a Nx(2 or 3) matrix of the raw 3D scatter data
% Output: data is a structure containing either
%             data.x and data.y for 2D input
%             and
%             data.x, data.y and data.z for 3D input
% Dr. A. I. Hanna (2005)
function [data, mean_PC] = fit_ellipse(PC);
% Check to see that there is more than one data point.
if(size(PC,1) < 2)
    return;
end
mean_PC = mean(PC);
PC = PC - ones(size(PC,1),1)*mean(PC);
[V, D] = eig(PC'*PC);
ProjC = (V'*PC')';
smax = max(abs(ProjC));
if size(PC,2) == 2
    theta = linspace(0, 2*pi, 100);
    x = cos(theta);
    y = sin(theta);
    C = [x(:)*smax(1) y(:)*smax(2)];
    C = (V*C')';
    x = C(:,1); y = C(:,2);;
    data.x = x + mean_PC(1);
    data.y = y + mean_PC(2);
else
    % Create a sphere
    [x,y,z] = sphere(20);
    [mm,nn] = size(x);
    C = [x(:)*smax(1) y(:)*smax(2) z(:)*smax(3)];
    C = (V*C')';
    x = C(:,1); y = C(:,2); z = C(:,3);
    x = reshape(x,mm,nn);
    y = reshape(y,mm,nn);
    z = reshape(z,mm,nn);
    data.x = x + mean_PC(1);
    data.y = y + mean_PC(2);
    data.z = z + mean_PC(3);
end
return;
% function [X, Y, Z] = poly3dfit(x, y, z, O, N)
%
% Input Params:
%            x - X Coordinates
%            y - Y Coordinates
%            z - Z Coordinates
%            O - a 1x2 vector conatining the order of the polynomials used
%                for the 'y' and 'z' axis respectively, (default O = [2,2]).
%            N - the number of data points used in the interpolation,
%                (default N = 100)
%
% Output Params :
%           X, Y, Z - the N coordinates of the fitted curve.
%
% Example:
%         x = -10:.03:10;%
%         y = exp(x);
%         z = abs(x);
%         y = y + .3*randn(size(y));
%         z = z + 1*randn(size(z));
%         plot3(x, y, z, 'o'); grid on; hold on;
%         [X,Y,Z] = poly3dfit(x, y, z, [5,10], 100);
%         plot3(X, Y, Z, 'r', 'LineWidth', 2);
%
%  Dr. A. I. Hanna 2005.
function [X, Y, Z] = poly3dfit(x, y, z, O, N)
if (nargin < 3)
    fprintf('Must have at least 3 input vectors, x, y, z!!!');
    X = []; Y = []; Z = [];
    return;
end
x = x(:); y = y(:); z = z(:);
if (nargin == 3)
    O = [2, 2];
    N = 100;
end
if (nargin == 4)
    O = O(:);
    if(length(O) >2)
        fprintf('O only needs 2 components!!!');
        X = []; Y = []; Z = [];
    end
    N = 100;
end
% Caclulate the best fit against the z-data
[pz, s] = polyfit(x, z, O(1));
fz = polyval(pz, x);
% Caclulate the best fit against the y-data
[py, s] = polyfit(x, y, O(2));
fy = polyval(py, x);
X = linspace(min(x), max(x), N);
Y = polyval(py, X);
Z = polyval(pz, X);
X = X(:); Y = Y(:); Z = Z(:);
return;
